function [x,iter] = gpu_DecSub(Image,Kernel,Sigma,lambda0,lambda1,NIter)

%% Initialize

SizeImg = size(Image);
rho     = 1;
rhop    = 1;
eta     = 1;
Kernel  = gpuArray(Kernel);
VAR     = Sigma.^2;
clearvars Sigma
lim     = 10;
Lim     = 100;

%% Initialize Variables
zp      = zeros(SizeImg);
z1x     = zeros(SizeImg);
z1y     = zeros(SizeImg);
z1z     = zeros(SizeImg);
z2x     = zeros(SizeImg);
z2y     = zeros(SizeImg);
z2z     = zeros(SizeImg);
z2xy    = zeros(SizeImg);
z2xz    = zeros(SizeImg);
z2yz    = zeros(SizeImg);

up      = zeros(SizeImg);
u1x     = zeros(SizeImg);
u1y     = zeros(SizeImg);
u1z     = zeros(SizeImg);
u2x     = zeros(SizeImg);
u2y     = zeros(SizeImg);
u2z     = zeros(SizeImg);
u2xy    = zeros(SizeImg);
u2xz    = zeros(SizeImg);
u2yz    = zeros(SizeImg);

x       = zeros(SizeImg);
T1      = zeros(SizeImg);
T2      = zeros(SizeImg);
T3      = zeros(SizeImg);

%% Compute Kernels
kernel        = Kernel./sum(Kernel,3);
Kernel        = zeros(SizeImg);
Kernel(1,1,:) = kernel(1,1,:);
A             = fftn(Kernel,SizeImg);
clearvars Kernel kernel
At            = conj(A);

AtA           = gather(At.*A)./VAR;
AtImg         = At.*fftn(Image,SizeImg)./VAR;
A             = gather(A);
At            = gather(At);

%% Total Generalalized Variation
dx               = [1,-1,0] ;
dy               = [1,-1,0]';
dz(:,:,1)        =  1;
dz(:,:,2)        = -1;
dx               = fftn(dx,SizeImg);
dy               = fftn(dy,SizeImg);
dz               = fftn(dz,SizeImg);
dtx              = conj(dx);
dty              = conj(dy);
dtz              = conj(dz);

DtD              = dtx.*dx + dty.*dy + dtz.*dz;

A11 = AtA + rhop + rho.*(DtD); A12 =      - rho.*       dtx ; A13 =      - rho.*       dty ; A14 =       -rho.*       dtz ;
A21 =            - rho.*(dx ); A22 =  rho + eta.*(DtD)      ; A23 =        eta.*(dy ).*dtx ; A24 =        eta.*(dz ).*dtx ;
A31 =            - rho.*(dy ); A32 =        eta.*(dx ).*dty ; A33 =  rho + eta.*(DtD)      ; A34 =        eta.*(dz ).*dty ;
A41 =            - rho.*(dz ); A42 =        eta.*(dx ).*dtz ; A43 =        eta.*(dy ).*dtz ; A44 =  rho + eta.*(DtD)      ;

C11 =   ( (A22.*A33.*A44) + (A23.*A34.*A42) + (A24.*A32.*A43) - (A42.*A33.*A24)- (A43.*A34.*A22) - (A44.*A32.*A23) );
C12 =  -( (A21.*A33.*A44) + (A23.*A34.*A41) + (A24.*A31.*A43) - (A41.*A33.*A24)- (A43.*A34.*A21) - (A44.*A31.*A23) );
C13 =   ( (A21.*A32.*A44) + (A22.*A34.*A41) + (A24.*A31.*A42) - (A41.*A32.*A24)- (A42.*A34.*A21) - (A44.*A31.*A22) );
C14 =  -( (A21.*A32.*A43) + (A22.*A33.*A41) + (A23.*A31.*A42) - (A41.*A32.*A23)- (A42.*A33.*A21) - (A43.*A31.*A22) );

C21 =  -( (A12.*A33.*A44) + (A13.*A34.*A42) + (A14.*A32.*A43) - (A42.*A33.*A14)- (A43.*A34.*A12) - (A44.*A32.*A13) );
C22 =   ( (A11.*A33.*A44) + (A13.*A34.*A41) + (A14.*A31.*A43) - (A41.*A33.*A14)- (A43.*A34.*A11) - (A44.*A31.*A13) );
C23 =  -( (A11.*A32.*A44) + (A12.*A34.*A41) + (A14.*A31.*A42) - (A41.*A32.*A14)- (A42.*A34.*A11) - (A44.*A31.*A12) );
C24 =   ( (A11.*A32.*A43) + (A12.*A33.*A41) + (A13.*A31.*A42) - (A41.*A32.*A13)- (A42.*A33.*A11) - (A43.*A31.*A12) );

C31 =   ( (A12.*A23.*A44) + (A13.*A24.*A42) + (A14.*A22.*A43) - (A42.*A23.*A14)- (A43.*A24.*A12) - (A44.*A22.*A13) );
C32 =  -( (A11.*A23.*A44) + (A13.*A24.*A41) + (A14.*A21.*A43) - (A41.*A23.*A14)- (A43.*A24.*A11) - (A44.*A21.*A13) );
C33 =   ( (A11.*A22.*A44) + (A12.*A24.*A41) + (A14.*A21.*A42) - (A41.*A22.*A14)- (A42.*A24.*A11) - (A44.*A21.*A12) );
clearvars A44
C34 =  -( (A11.*A22.*A43) + (A12.*A23.*A41) + (A13.*A21.*A42) - (A41.*A22.*A13)- (A42.*A23.*A11) - (A43.*A21.*A12) );
clearvars A42 A43
C41 =  -( (A12.*A23.*A34) + (A13.*A24.*A32) + (A14.*A22.*A33) - (A32.*A23.*A14)- (A33.*A24.*A12) - (A34.*A22.*A13) );
C42 =   ( (A11.*A23.*A34) + (A13.*A24.*A31) + (A14.*A21.*A33) - (A31.*A23.*A14)- (A33.*A24.*A11) - (A34.*A21.*A13) );
C43 =  -( (A11.*A22.*A34) + (A12.*A24.*A31) + (A14.*A21.*A32) - (A31.*A22.*A14)- (A32.*A24.*A11) - (A34.*A21.*A12) );
clearvars A14 A24 A34
C44 =   ( (A11.*A22.*A33) + (A12.*A23.*A31) + (A13.*A21.*A32) - (A31.*A22.*A13)- (A32.*A23.*A11) - (A33.*A21.*A12) );
clearvars A12 A13   A22 A23    A32 A33

detA = 1./(A11.*C11 + A21.*C21 + A31.*C31 + A41.*C41);
clearvars A11 A21 A31 A41

iA11 = C11.*detA ; clearvars C11 ; iA21 = C12.*detA ; clearvars C12 ; iA31 = C13.*detA ;clearvars C13 ; iA41 = C14.*detA ; clearvars C14 ;
iA12 = C21.*detA ; clearvars C21 ; iA22 = C22.*detA ; clearvars C22 ; iA32 = C23.*detA ;clearvars C23 ; iA42 = C24.*detA ; clearvars C24 ;
iA13 = C31.*detA ; clearvars C31 ; iA23 = C32.*detA ; clearvars C32 ; iA33 = C33.*detA ;clearvars C33 ; iA43 = C34.*detA ; clearvars C34 ;
iA14 = C41.*detA ; clearvars C41 ; iA24 = C42.*detA ; clearvars C42 ; iA34 = C43.*detA ;clearvars C34 ; iA44 = C44.*detA ; clearvars C44 ;
clearvars detA

%% Start ADMM iterations
WaitTics         = NIter;
WaitADMM         = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
for iter=1:NIter
    RBCyc = ~mod(iter,round(10^(round(log10(iter)*10)/10))) || iter<10 || iter==NIter;
    
    %% X and T updates
    
    vp    = gpuArray(zp         - up  );
    v1x   = gpuArray(z1x        - u1x );
    v1y   = gpuArray(z1y        - u1y );
    v1z   = gpuArray(z1z        - u1z );
    v2x   = gpuArray(z2x        - u2x );
    v2y   = gpuArray(z2y        - u2y );
    v2z   = gpuArray(z2z        - u2z );
    v2xy  = gpuArray(z2xy       - u2xy);
    v2xz  = gpuArray(z2xz       - u2xz);
    v2yz  = gpuArray(z2yz       - u2yz);
    
    xnum1 =    AtImg + rhop.*fftn(vp ,SizeImg) + rho.*fftn(Dt(v1x ,2) ,SizeImg) + rho.*fftn(Dt(v1y ,1),SizeImg) + rho.*fftn(Dt(v1z ,3),SizeImg);
    clearvars vp
    xnum2 =          - rho .*fftn(v1x,SizeImg) + eta.*fftn(D( v2x ,2) ,SizeImg) + eta.*fftn(D( v2xy,1),SizeImg) + eta.*fftn(D( v2xz,3),SizeImg);
    clearvars v1x v2x
    xnum3 =          - rho .*fftn(v1y,SizeImg) + eta.*fftn(D( v2xy,2) ,SizeImg) + eta.*fftn(D( v2y ,1),SizeImg) + eta.*fftn(D( v2yz,3),SizeImg);
    clearvars v1y v2xy v2y
    xnum4 =          - rho .*fftn(v1z,SizeImg) + eta.*fftn(D( v2xz,2) ,SizeImg) + eta.*fftn(D( v2yz,1),SizeImg) + eta.*fftn(D( v2z ,3),SizeImg);
    clearvars v1z v2xz v2yz v2z
    
    if RBCyc
        x_old  = gather(x);
        T1_old = T1;
        T2_old = T2;
        T3_old = T3;
    end
    
    x     = gpuArray(iA11).*xnum1 + gpuArray(iA12).*xnum2 + gpuArray(iA13).*xnum3 + gpuArray(iA14).*xnum4;
    T1    = gpuArray(iA21).*xnum1 + gpuArray(iA22).*xnum2 + gpuArray(iA23).*xnum3 + gpuArray(iA24).*xnum4;
    T2    = gpuArray(iA31).*xnum1 + gpuArray(iA32).*xnum2 + gpuArray(iA33).*xnum3 + gpuArray(iA34).*xnum4;
    T3    = gpuArray(iA41).*xnum1 + gpuArray(iA42).*xnum2 + gpuArray(iA43).*xnum3 + gpuArray(iA44).*xnum4;
    clearvars xnum1 xnum2 xnum3 xnum4
    
    x     = ifftn(x ,SizeImg);
    T1    = ifftn(T1,SizeImg);
    T2    = ifftn(T2,SizeImg);
    T3    = ifftn(T3,SizeImg);
    
    x     = sign(real(x )).*abs(x );
    T1    = sign(real(T1)).*abs(T1);
    T2    = sign(real(T2)).*abs(T2);
    T3    = sign(real(T3)).*abs(T3);
    
    if RBCyc
        x_old  = x  -  x_old;
        T1_old = T1 - T1_old;
        T2_old = T2 - T2_old;
        T3_old = T3 - T3_old;
    end
    
    %% Check Waitbar exist
    Flag = CheckWaitbar(WaitADMM);
    switch Flag
        case 1
            x  = [];
            x  = gather(x);
            clearvars -except x iter
            return
        case 2
            x   = max(x,0);
            x   = gather(x);
            clearvars -except x iter
            return
    end
    clearvars Flag
    
    %% Zp update
    vp    = x  + up;
    if RBCyc
        zp_old = zp;
    end
    
    zp    = max(vp,0);
    up    = vp - zp;
    clearvars vp
    if RBCyc
        Sp     = -rhop.*(zp - zp_old);
        clearvars zp_old
        Spnorm =  rhop.*up;
        
        Rp     = sqrt(mean((x - zp).^2,'all'));
        Rpnorm = sqrt(max(mean(x.^2,'all'),mean( zp.^2,'all')));
        Rnormp = Rp./Rpnorm;
        clearvars Rp Rpnorm
    end
    zp   = gather(zp);
    up   = gather(up);
    
    %% Z1 update
    Dx    = D(x,2);
    v1x   = Dx - T1 + u1x;
    
    Dy    = D(x,1);
    v1y   = Dy -T2 + u1y;
    
    Dz    = D(x,3);
    v1z   = Dz - T3 + u1z;
    
    k     = lambda0/rho;
    vnorm = sqrt(v1x.^2 + v1y.^2 + v1z.^2);
    
    if RBCyc
        z1x_old = z1x;
    end
    z1x   = cSk(v1x,vnorm,k);
    u1x   = v1x - z1x;
    clearvars v1x
    if RBCyc
        z1x_old   =          z1x       - z1x_old   ;
        S         = -rho.*Dt(T1_old    + z1x_old,2);
        S1norm    =  rho.*Dt(u1x                ,2);
        
        S1a       =  rho.*(D(-x_old,2) + z1x_old  );
        clearvars z1x_old
        S1anorm   =  rho.*u1x;
        
        R         = mean((Dx - z1x - T1).^2,'all');
        R1norm    = mean((Dx       - T1).^2,'all');
        R2norm    = mean((     z1x     ).^2,'all');
    end
    clearvars Dx
    z1x       = gather(z1x);
    u1x       = gather(u1x);
    
    if RBCyc
        z1y_old = z1y;
    end
    z1y   = cSk(v1y,vnorm,k);
    u1y   = v1y - z1y;
    clearvars v1y
    if RBCyc
        z1y_old   =             z1y       - z1y_old    ;
        S         = S - rho.*Dt(T2_old    + z1y_old ,1);
        S2norm    =     rho.*Dt(u1y                 ,1);
        
        S2a       =     rho.*(D(-x_old,1) + z1y_old   );
        clearvars z1y_old
        S2anorm   =     rho.*u1y;
        
        R         = R      + mean((Dy - z1y - T2).^2,'all');
        R1norm    = R1norm + mean((Dy       - T2).^2,'all');
        R2norm    = R2norm + mean((     z1y     ).^2,'all');
    end
    clearvars Dy
    z1y       = gather(z1y);
    u1y       = gather(u1y);
    
    if RBCyc
        z1z_old = z1z;
    end
    z1z   = cSk(v1z,vnorm,k);
    clearvars vnorm
    u1z   = v1z - z1z;
    clearvars v1z
    if RBCyc
        z1z_old   =             z1z       - z1z_old    ;
        S         = S - rho.*Dt(T3_old    + z1z_old ,3);
        S3norm    =     rho.*Dt(u1z                 ,3);
        
        S3a       =     rho.*(D(-x_old,3) + z1z_old   );
        clearvars x_old z1z_old
        S3anorm   =     rho.*u1z;
        
        SNp       =  max(mean( Spnorm.^2                   ,'all'),mean((S1norm + S2norm + S3norm  - S ).^2,'all'));
        SN        =  max(mean((S1norm + S2norm + S3norm).^2,'all'),mean((Spnorm                    - Sp).^2,'all'));
        clearvars  Spnorm S1norm S2norm S3norm
        
        Snormp    = sqrt(mean(Sp.^2,'all')/SNp);
        clearvars Sp SNp
        S         = sqrt(mean(S.^2,'all') + mean(S1a.^2,'all') + mean(S2a.^2,'all') + mean(S3a.^2,'all'));
                
        R         = sqrt(R      + mean((Dz - z1z - T3).^2,'all'));
        R1norm    =      R1norm + mean((Dz       - T3).^2,'all');
        R2norm    =      R2norm + mean((     z1z     ).^2,'all');
        
        RN        = sqrt(max(R1norm,R2norm));
        clearvars R1norm R2norm

        Rnorm     = R/RN;
        clearvars R RN
    end
    clearvars Dz
    z1z       = gather(z1z);
    u1z       = gather(u1z);
    
    %% Z2 Update
    Htx  = Dt(T1,2);
    v2x  = Htx  + u2x;
    
    Htxy = Dt(T1,1) + Dt(T2,2);
    v2xy = Htxy + u2xy;
    
    Hty  = Dt(T2,1);
    v2y  = Hty  + u2y;
    
    Htxz = Dt(T1,3) + Dt(T3,2);
    v2xz = Htxz + u2xz;
    T1   = gather(T1);
    
    Htyz = Dt(T2,3) + Dt(T3,1);
    v2yz = Htyz + u2yz;
    T2   = gather(T2);
    
    Htz  = Dt(T3,3);
    v2z  = Htz  + u2z;
    T3   = gather(T3);
    
    k    = lambda1/eta;
    vnorm = sqrt(v2x.^2+v2xy.^2+v2y.^2+v2xz.^2+v2yz.^2+v2z.^2);
    
    if RBCyc
        z2x_old = z2x;
    end
    z2x  = cSk(v2x ,vnorm,k);
    u2x  = v2x  - z2x ;
    clearvars v2x
    if RBCyc
        s1        = - eta.*D(z2x - z2x_old,2);
        clearvars z2x_old
        s1norm    =   eta.*D(u2x          ,2);
        
        r         = mean((Htx - z2x).^2,'all');
        r1norm    = mean((Htx      ).^2,'all');
        r2norm    = mean((      z2x).^2,'all');
    end
    clearvars Htx
    z2x      = gather(z2x);
    u2x      = gather(u2x);
    
    if RBCyc
        z2xy_old = z2xy;
    end
    z2xy = cSk(v2xy,vnorm,k);
    u2xy = v2xy - z2xy;
    clearvars v2xy
    if RBCyc
        z2xy_old  =                     z2xy      - z2xy_old    ;
        s1        = s1     - eta.*D(Dt(-T2_old,2) + z2xy_old ,1);
        s1norm    = s1norm + eta.*D(                u2xy    , 1);
        
        s2        =        - eta.*D(Dt(-T1_old,1) + z2xy_old ,2);
        clearvars z2xy_old
        s2norm    =          eta.*D(                u2xy    , 2);
        
        r         = r      + mean((Htxy - z2xy).^2,'all');
        r1norm    = r1norm + mean((Htxy       ).^2,'all');
        r2norm    = r2norm + mean((       z2xy).^2,'all');
    end
    clearvars Htxy
    z2xy     = gather(z2xy);
    u2xy     = gather(u2xy);
    
    if RBCyc
        z2y_old = z2y ;
    end
    z2y  = cSk(v2y ,vnorm,k);
    u2y  = v2y  - z2y ;
    clearvars v2y
    if RBCyc
        s2        = s2     - eta.*(D(z2y - z2y_old,1));
        clearvars z2y_old
        s2norm    = s2norm + eta.*(D(      u2y    ,1));
        
        r         = r      + mean((Hty - z2y).^2,'all');
        r1norm    = r1norm + mean((Hty      ).^2,'all');
        r2norm    = r2norm + mean((      z2y).^2,'all');
    end
    clearvars Hty
    z2y      = gather(z2y);
    u2y      = gather(u2y);
    
    if RBCyc
        z2xz_old = z2xz;
    end
    z2xz = cSk(v2xz,vnorm,k);
    u2xz = v2xz - z2xz;
    clearvars v2xz
    if RBCyc
        z2xz_old  =                     z2xz      - z2xz_old    ;
        s1        = s1     - eta.*D(Dt(-T3_old,2) + z2xz_old ,3);
        s1norm    = s1norm + eta.*D(   u2xz                 , 3);
        s         =          mean(s1.^2,'all');
        
        sn        =      max(mean((S1anorm - S1a).^2,'all') ,  mean(s1norm.^2 ,'all'));
        clearvars S1a 
        SN        = SN + max(mean((s1norm  - s1 ).^2,'all') ,  mean(S1anorm.^2,'all'));
        clearvars S1anorm s1 s1norm 

        s3        =        - eta.*D(Dt(-T1_old,3) + z2xz_old ,2);
        s3norm    =          eta.*D(                u2xz    , 2);
        
        r         = r      + mean((Htxz - z2xz).^2,'all');
        r1norm    = r1norm + mean((Htxz       ).^2,'all');
        r2norm    = r2norm + mean((       z2xz).^2,'all');
    end
    clearvars Htxz
    z2xz     = gather(z2xz);
    u2xz     = gather(u2xz);
    
    if RBCyc
        z2yz_old = z2yz;
    end
    z2yz = cSk(v2yz,vnorm,k);
    u2yz = v2yz - z2yz;
    clearvars v2yz
    if RBCyc
        z2yz_old  =                     z2yz      - z2yz_old    ;
        s2        = s2     - eta.*D(Dt(-T3_old,1) + z2yz_old ,3);
        s2norm    = s2norm + eta.*D(                u2yz    , 3);
        s         = s      + mean(s2.^2,'all');
        
        sn        = sn + max(mean((S2anorm - S2a).^2,'all') ,  mean(s2norm.^2 ,'all'));
        clearvars S2a
        SN        = SN + max(mean((s2norm  - s2 ).^2,'all') ,  mean(S2anorm.^2,'all'));
        clearvars S2anorm s2 s2norm
        
        s3        = s3     - eta.*D( Dt(-T2_old,3) + z2yz_old ,1);
        s3norm    = s3norm + eta.*D(                 u2yz     ,1);
        
        r         = r      + mean((Htyz - z2yz).^2,'all');
        r1norm    = r1norm + mean((Htyz       ).^2,'all');
        r2norm    = r2norm + mean((       z2yz).^2,'all');
    end
    clearvars Htyz
    z2yz     = gather(z2yz);
    u2yz     = gather(u2yz);
    
    if RBCyc
        z2z_old = z2z;
    end
    z2z  = cSk(v2z ,vnorm,k);
    u2z  = v2z  - z2z ;
    clearvars v2z vnorm
    if RBCyc
        s3        = s3     - eta.*D(z2z - z2z_old,3);
        clearvars z2z_old
        s3norm    = s3norm + eta.*D(u2z          ,3);
        s         = sqrt(s + mean(s3.^2,'all'));
        
        sn        = sqrt(sn + max(mean((S3anorm - S3a).^2,'all') ,  mean(s3norm.^2 ,'all')));
        clearvars  S3a
        SN        = sqrt(SN + max(mean((s3norm  - s3 ).^2,'all') ,  mean(S3anorm.^2,'all')));
        clearvars S3anorm s3 s3norm
        
        snorm     = s/sn;
        clearvars s sn
        Snorm     = S/SN;
        clearvars S SN
        
        r         = sqrt(r      + mean((Htz - z2z).^2,'all'));
        r1norm    =      r1norm + mean((Htz      ).^2,'all');
        r2norm    =      r2norm + mean((      z2z).^2,'all');
        rn        = sqrt(max(r1norm,r2norm));
        clearvars r1norm r2norm
        rnorm     = r/rn;
        clearvars r rn
    end
    clearvars Htz
    z2z      = gather(z2z);
    u2z      = gather(u2z);
    
    
    if RBCyc
        %% Rhop Update (RB)
        tau_rhop = sqrt(Rnormp/Snormp);
        if isnan(tau_rhop) || tau_rhop==0 || tau_rhop==inf
            if rhop > 1
                tau_rhop = lim^(-1);
            elseif rhop < 1
                tau_rhop = lim^( 1);
            else
                tau_rhop = 1;
            end
        end
        tau_rhop = max(min(tau_rhop,10^(Lim)/rhop),10^(-Lim)/rhop);
        rhop     = rhop.*tau_rhop;
        up       = up  ./tau_rhop;
        
        %% Rho Update (RB)
        tau_rho = gather(sqrt(Rnorm/Snorm));
        if isnan(tau_rho) || tau_rho==0 || tau_rho==inf
            if rho > 1
                tau_rho = lim^(-1);
            elseif rho < 1
                tau_rho = lim^( 1);
            else
                tau_rho = 1;
            end
        end
        tau_rho = max(min(tau_rho,10^(Lim)/rho),10^(-Lim)/rho);
        rho     = rho.*tau_rho;
        u1x     = u1x./tau_rho;
        u1y     = u1y./tau_rho;
        u1z     = u1z./tau_rho;
        
        %% Eta Update (RB)
        tau_eta = gather(sqrt(rnorm/snorm));
        if isnan(tau_eta) || tau_eta==0 || tau_eta==inf
            if eta > 1
                tau_eta = lim^(-1);
            elseif eta < 1
                tau_eta = lim^( 1);
            else
                tau_eta = 1;
            end
        end
        tau_eta = max(min(tau_eta,10^(Lim)/eta),10^(-Lim)/eta);
        eta     = eta .*tau_eta;
        u2x     = u2x ./tau_eta;
        u2xy    = u2xy./tau_eta;
        u2y     = u2y ./tau_eta;
        u2xz    = u2xz./tau_eta;
        u2yz    = u2yz./tau_eta;
        u2z     = u2z ./tau_eta;
        
        %% Update Denominator
        if tau_rhop ~=1 && tau_rho ~=1 && tau_eta~=1
            A11 = AtA + rhop + rho.*(DtD); A12 =      - rho.*       dtx ; A13 =      - rho.*       dty ; A14 =       -rho.*       dtz ;
            A21 =            - rho.*(dx ); A22 =  rho + eta.*(DtD)      ; A23 =        eta.*(dy ).*dtx ; A24 =        eta.*(dz ).*dtx ;
            A31 =            - rho.*(dy ); A32 =        eta.*(dx ).*dty ; A33 =  rho + eta.*(DtD)      ; A34 =        eta.*(dz ).*dty ;
            A41 =            - rho.*(dz ); A42 =        eta.*(dx ).*dtz ; A43 =        eta.*(dy ).*dtz ; A44 =  rho + eta.*(DtD)      ;
            
            C11 =   ( (A22.*A33.*A44) + (A23.*A34.*A42) + (A24.*A32.*A43) - (A42.*A33.*A24)- (A43.*A34.*A22) - (A44.*A32.*A23) );
            C12 =  -( (A21.*A33.*A44) + (A23.*A34.*A41) + (A24.*A31.*A43) - (A41.*A33.*A24)- (A43.*A34.*A21) - (A44.*A31.*A23) );
            C13 =   ( (A21.*A32.*A44) + (A22.*A34.*A41) + (A24.*A31.*A42) - (A41.*A32.*A24)- (A42.*A34.*A21) - (A44.*A31.*A22) );
            C14 =  -( (A21.*A32.*A43) + (A22.*A33.*A41) + (A23.*A31.*A42) - (A41.*A32.*A23)- (A42.*A33.*A21) - (A43.*A31.*A22) );
            
            C21 =  -( (A12.*A33.*A44) + (A13.*A34.*A42) + (A14.*A32.*A43) - (A42.*A33.*A14)- (A43.*A34.*A12) - (A44.*A32.*A13) );
            C22 =   ( (A11.*A33.*A44) + (A13.*A34.*A41) + (A14.*A31.*A43) - (A41.*A33.*A14)- (A43.*A34.*A11) - (A44.*A31.*A13) );
            C23 =  -( (A11.*A32.*A44) + (A12.*A34.*A41) + (A14.*A31.*A42) - (A41.*A32.*A14)- (A42.*A34.*A11) - (A44.*A31.*A12) );
            C24 =   ( (A11.*A32.*A43) + (A12.*A33.*A41) + (A13.*A31.*A42) - (A41.*A32.*A13)- (A42.*A33.*A11) - (A43.*A31.*A12) );
            
            C31 =   ( (A12.*A23.*A44) + (A13.*A24.*A42) + (A14.*A22.*A43) - (A42.*A23.*A14)- (A43.*A24.*A12) - (A44.*A22.*A13) );
            C32 =  -( (A11.*A23.*A44) + (A13.*A24.*A41) + (A14.*A21.*A43) - (A41.*A23.*A14)- (A43.*A24.*A11) - (A44.*A21.*A13) );
            C33 =   ( (A11.*A22.*A44) + (A12.*A24.*A41) + (A14.*A21.*A42) - (A41.*A22.*A14)- (A42.*A24.*A11) - (A44.*A21.*A12) );
            clearvars A44
            C34 =  -( (A11.*A22.*A43) + (A12.*A23.*A41) + (A13.*A21.*A42) - (A41.*A22.*A13)- (A42.*A23.*A11) - (A43.*A21.*A12) );
            clearvars A42 A43
            C41 =  -( (A12.*A23.*A34) + (A13.*A24.*A32) + (A14.*A22.*A33) - (A32.*A23.*A14)- (A33.*A24.*A12) - (A34.*A22.*A13) );
            C42 =   ( (A11.*A23.*A34) + (A13.*A24.*A31) + (A14.*A21.*A33) - (A31.*A23.*A14)- (A33.*A24.*A11) - (A34.*A21.*A13) );
            C43 =  -( (A11.*A22.*A34) + (A12.*A24.*A31) + (A14.*A21.*A32) - (A31.*A22.*A14)- (A32.*A24.*A11) - (A34.*A21.*A12) );
            clearvars A14 A24 A34
            C44 =   ( (A11.*A22.*A33) + (A12.*A23.*A31) + (A13.*A21.*A32) - (A31.*A22.*A13)- (A32.*A23.*A11) - (A33.*A21.*A12) );
            clearvars A12 A13   A22 A23    A32 A33
            
            detA = 1./(A11.*C11 + A21.*C21 + A31.*C31 + A41.*C41);
            clearvars A11 A21 A31 A41
            
            iA11 = C11.*detA ; clearvars C11 ; iA21 = C12.*detA ; clearvars C12 ; iA31 = C13.*detA ;clearvars C13 ; iA41 = C14.*detA ; clearvars C14 ;
            iA12 = C21.*detA ; clearvars C21 ; iA22 = C22.*detA ; clearvars C22 ; iA32 = C23.*detA ;clearvars C23 ; iA42 = C24.*detA ; clearvars C24 ;
            iA13 = C31.*detA ; clearvars C31 ; iA23 = C32.*detA ; clearvars C32 ; iA33 = C33.*detA ;clearvars C33 ; iA43 = C34.*detA ; clearvars C34 ;
            iA14 = C41.*detA ; clearvars C41 ; iA24 = C42.*detA ; clearvars C42 ; iA34 = C43.*detA ;clearvars C34 ; iA44 = C44.*detA ; clearvars C44 ;
            clearvars detA
        end
    end
    
    %% Check Waitbar exist
    Flag = CheckWaitbar(WaitADMM);
    switch Flag
        case 1
            x  = [];
            clearvars -except x iter
            return
        case 2
            x   = max(x,0);
            x   = gather(x);
            clearvars -except x iter
            return
    end
    clearvars Flag
    WaitADMM.Send;
    
end
WaitADMM.Destroy;
x   = max(x,0);
x   = gather(x);
clearvars -except x iter
end

function z = cSk(v1,vnorm,k)
z           = zeros(size(v1));
z(vnorm>=k) = v1(vnorm>=k)- k .* v1(vnorm>=k)./vnorm(vnorm>=k);
clearvars -except z
end

function Grad = D(x,dim)
Grad        = x - circshift(x,+1,dim);
clearvars -except Grad
end

function Grad = Dt(x,dim)
Grad        = x - circshift(x,-1,dim);
clearvars -except Grad
end